<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to elessi-theme/woocommerce/single-product/up-sells.php.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  NasaTheme
 * @package Elessi-theme/WooCommerce
 * @version 9.6.0
 */
if (!defined('ABSPATH')) :
    exit;
endif;

if ($upsells) :
    global $nasa_opt;

    $_delay = 0;
    $_delay_item = (isset($nasa_opt['delay_overlay']) && (int) $nasa_opt['delay_overlay']) ? (int) $nasa_opt['delay_overlay'] : 100;
    
    $layout_buttons_class = '';
    
    if (isset($nasa_opt['loop_layout_buttons']) && $nasa_opt['loop_layout_buttons'] != '') :
        $layout_buttons_class = ' nasa-' . $nasa_opt['loop_layout_buttons'];
    endif;

    $columns_desk = !isset($nasa_opt['relate_columns_desk']) || !(int) $nasa_opt['relate_columns_desk'] ? 5 : (int) $nasa_opt['relate_columns_desk'];
    $columns_tablet = !isset($nasa_opt['relate_columns_tablet']) || !(int) $nasa_opt['relate_columns_tablet'] ? 3 : (int) $nasa_opt['relate_columns_tablet'];
    $columns_small = isset($nasa_opt['relate_columns_small']) ? $nasa_opt['relate_columns_small'] : 2;
    $columns_small_slide = $columns_small == '1.5-cols' ? 1 : (int) $columns_small;
    
    if (!$columns_small) :
        $columns_small_slide = 2;
    endif;

    $ex_class = 'row related-product nasa-slider-wrap related up-sell products grid nasa-relative mobile-margin-bottom-20';
    $head_class = 'nasa-title-relate';
    if (isset($nasa_opt['product_detail_layout']) && $nasa_opt['product_detail_layout'] == 'new-3') :
        $layout_buttons_class .= ' nasa-nav-top';
        $ex_class .= ' title-align-left margin-bottom-20';
        $head_class .= ' padding-left-0 padding-right-0';
    else :
        $layout_buttons_class .= ' nasa-nav-radius';
        $ex_class .= ' margin-bottom-30';
        $head_class .= ' text-center';
    endif;
    
    $data_attrs = array(
        'data-columns="' . esc_attr($columns_desk) . '"',
        'data-columns-small="' . esc_attr($columns_small_slide) . '"',
        'data-columns-tablet="' . esc_attr($columns_tablet) . '"',
        'data-switch-tablet="' . elessi_switch_tablet() . '"',
        'data-switch-desktop="' . elessi_switch_desktop() . '"',
    );

    if ($columns_small == '1.5-cols') :
        $data_attrs[] = 'data-padding-small="20%"';
    endif;
    
    if (isset($nasa_opt['relate_slide_auto']) && $nasa_opt['relate_slide_auto']) :
        $data_attrs[] = 'data-autoplay="true"';
    endif;

    if (isset($nasa_opt['relate_slide_loop']) && $nasa_opt['relate_slide_loop']) :
        $data_attrs[] = 'data-loop="true"';
    endif;
    
    $arr_attrs = apply_filters('nasa_attrs_relate_wrap', $data_attrs);
    
    $attrs_str = !empty($arr_attrs) ? ' ' . implode(' ', $arr_attrs) : '';
    
    $class_slider = 'ns-items-gap nasa-slick-slider nasa-slick-nav products grid' . $layout_buttons_class;
    
    $heading = apply_filters('woocommerce_product_upsells_products_heading', __('You may also like&hellip;', 'elessi-theme'));
    ?>

    <div class="<?php echo esc_attr($ex_class); ?>">
        <?php if ($heading) : ?>
            <div class="large-12 columns">
                <h3 class="<?php echo esc_attr($head_class); ?>">
                    <?php echo esc_html($heading); ?>
                </h3>
            </div>
        <?php endif; ?>
        
        <div class="large-12 columns">
            <div class="<?php echo esc_attr($class_slider); ?>"<?php echo $attrs_str; ?>>
                <?php
                foreach ($upsells as $upsell):
                    $post_object = get_post($upsell->get_id());
                    setup_postdata($GLOBALS['post'] = & $post_object);

                    // Product Item
                    wc_get_template('content-product.php', array(
                        '_delay' => $_delay,
                        'wrapper' => 'div'
                    ));
                    // End Product Item

                    $_delay += $_delay_item;
                endforeach;
                ?>
            </div>
        </div>
    </div>
    <?php
endif;

wp_reset_postdata();
