<?php
/**
 * Shortcode [nasa_share ...]
 * 
 * @global type $post
 * @global type $nasa_opt
 * @global type $wp
 * @param type $atts
 * @param string $content
 * @return string
 */
function nasa_sc_share($atts = array(), $content = null) {
    extract(shortcode_atts(array(
        'title' => '',
        'el_class' => '',
        'label' => ''
    ), $atts));
    
    global $post, $nasa_opt;
    
    if (isset($post->ID)) {
        $permalink = get_permalink($post->ID);
        $featured_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'large');
        $featured_image_2 = isset($featured_image['0']) ? $featured_image['0'] : (isset($nasa_opt['site_logo']) ? $nasa_opt['site_logo'] : '#');
        $post_title = rawurlencode(get_the_title($post->ID));
    } else {
        global $wp;
        $permalink = home_url($wp->request);
        $featured_image_2 = isset($nasa_opt['site_logo']) ? $nasa_opt['site_logo'] : '#';
        $post_title = get_bloginfo('name', 'display');
    }
    
    $class_wrap = 'ns-social social-icons nasa-share nasa-flex';
    $class_wrap .= $el_class != '' ? ' ' . esc_attr($el_class) : '';
    
    $share_wrap_start = $title ? '<div class="nasa-share-title">' . $title . '</div>' : '';
    
    if ($label === '1') {
        $label_content = '<svg width="20" height="20" viewBox="0 0 32 32" fill="currentColor">
<path d="M26.129 2.139c-2.355 0-4.265 1.91-4.265 4.265 0 0.409 0.061 0.803 0.168 1.178l-12.469 5.226c-0.737-1.277-2.114-2.139-3.693-2.139-2.355 0-4.265 1.91-4.265 4.265s1.91 4.265 4.265 4.265c1.234 0 2.343-0.527 3.122-1.366l8.034 5.774c-0.314 0.594-0.494 1.27-0.494 1.988 0 2.356 1.91 4.266 4.265 4.266s4.265-1.91 4.265-4.266c0-2.355-1.91-4.264-4.265-4.264-1.253 0-2.376 0.544-3.157 1.404l-8.023-5.765c0.33-0.605 0.518-1.299 0.518-2.037 0-0.396-0.058-0.778-0.159-1.143l12.478-5.23c0.741 1.26 2.107 2.108 3.675 2.108 2.355 0 4.265-1.91 4.265-4.266 0-2.355-1.91-4.265-4.265-4.265zM20.798 22.398c1.764 0 3.199 1.435 3.199 3.198s-1.435 3.199-3.199 3.199c-1.764 0-3.199-1.435-3.199-3.199s1.435-3.198 3.199-3.198zM5.871 18.133c-1.764 0-3.199-1.435-3.199-3.199s1.435-3.199 3.199-3.199 3.199 1.435 3.199 3.199c0 1.764-1.435 3.199-3.199 3.199zM26.129 9.603c-1.764 0-3.199-1.435-3.199-3.199s1.435-3.199 3.199-3.199c1.764 0 3.199 1.435 3.199 3.199s-1.435 3.199-3.199 3.199z"/>
</svg>&nbsp;&nbsp;' . esc_html__('Share', 'nasa-core');
        $share_wrap_start .= '<div class="nasa-share-label">' . $label_content . '</div>';
    }
    
    $share_wrap_start .= '<div class="' . $class_wrap . '">';
    
    $share = '';
    
    /**
     * Twitter - X
     */
    if (isset($nasa_opt['social_icons']['twitter']) && $nasa_opt['social_icons']['twitter']) {
        $share .=
        '<a href="https://x.com/share?url=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on X', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 24 24" with="14.5" height="14.5" aria-hidden="true" fill="currentColor"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>' .
        '</a>';
    }
        
    /**
     * FaceBook
     */
    if (isset($nasa_opt['social_icons']['facebook']) && $nasa_opt['social_icons']['facebook']) {
        $share .=
        '<a href="https://www.facebook.com/sharer.php?u=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on Facebook', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 32 32" with="15" height="15" fill="currentColor"><path d="M 19.253906 2 C 15.311906 2 13 4.0821719 13 8.8261719 L 13 13 L 8 13 L 8 18 L 13 18 L 13 30 L 18 30 L 18 18 L 22 18 L 23 13 L 18 13 L 18 9.671875 C 18 7.884875 18.582766 7 20.259766 7 L 23 7 L 23 2.2050781 C 22.526 2.1410781 21.144906 2 19.253906 2 z"/></svg>' .
        '</a>';
    }
    
    /**
     * Pinterest
     */
    if (isset($nasa_opt['social_icons']['pinterest']) && $nasa_opt['social_icons']['pinterest']) {
        $share .=
        '<a href="https://pinterest.com/pin/create/button/?url=' . esc_url($permalink) . '&amp;media=' . esc_attr($featured_image_2) . '&amp;description=' . esc_attr($post_title) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Pin on Pinterest', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 16 16" width="16" height="16" fill="currentColor"><path d="M 7.5 1 C 3.910156 1 1 3.910156 1 7.5 C 1 10.253906 2.714844 12.605469 5.132813 13.554688 C 5.074219 13.039063 5.023438 12.25 5.152344 11.6875 C 5.273438 11.183594 5.914063 8.457031 5.914063 8.457031 C 5.914063 8.457031 5.722656 8.066406 5.722656 7.492188 C 5.722656 6.589844 6.246094 5.914063 6.898438 5.914063 C 7.453125 5.914063 7.71875 6.332031 7.71875 6.828125 C 7.71875 7.386719 7.363281 8.222656 7.183594 8.992188 C 7.027344 9.640625 7.507813 10.167969 8.144531 10.167969 C 9.300781 10.167969 10.1875 8.949219 10.1875 7.191406 C 10.1875 5.636719 9.070313 4.546875 7.472656 4.546875 C 5.625 4.546875 4.539063 5.933594 4.539063 7.367188 C 4.539063 7.925781 4.753906 8.527344 5.023438 8.851563 C 5.074219 8.917969 5.082031 8.972656 5.066406 9.039063 C 5.019531 9.242188 4.90625 9.6875 4.886719 9.777344 C 4.859375 9.894531 4.792969 9.921875 4.667969 9.863281 C 3.855469 9.484375 3.347656 8.296875 3.347656 7.34375 C 3.347656 5.292969 4.839844 3.410156 7.644531 3.410156 C 9.898438 3.410156 11.652344 5.015625 11.652344 7.164063 C 11.652344 9.402344 10.238281 11.207031 8.277344 11.207031 C 7.617188 11.207031 7 10.863281 6.789063 10.460938 C 6.789063 10.460938 6.460938 11.703125 6.382813 12.007813 C 6.234375 12.570313 5.839844 13.277344 5.574219 13.710938 C 6.183594 13.898438 6.828125 14 7.5 14 C 11.089844 14 14 11.089844 14 7.5 C 14 3.910156 11.089844 1 7.5 1 Z"/></svg>' .
        '</a>';
    }
    
    /**
     * Linkedin
     */
    if (isset($nasa_opt['social_icons']['linkedin']) && $nasa_opt['social_icons']['linkedin']) {
        $share .=
        '<a href="https://linkedin.com/shareArticle?mini=true&amp;url=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on Linkedin', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 30 30" width="16" height="16" fill="currentColor"><path d="M9,25H4V10h5V25z M6.501,8C5.118,8,4,6.879,4,5.499S5.12,3,6.501,3C7.879,3,9,4.121,9,5.499C9,6.879,7.879,8,6.501,8z M27,25h-4.807v-7.3c0-1.741-0.033-3.98-2.499-3.98c-2.503,0-2.888,1.896-2.888,3.854V25H12V9.989h4.614v2.051h0.065 c0.642-1.18,2.211-2.424,4.551-2.424c4.87,0,5.77,3.109,5.77,7.151C27,16.767,27,25,27,25z"/></svg>' .
        '</a>';
    }
    
    /**
     * Telegram
     */
    if (isset($nasa_opt['social_icons']['telegram']) && $nasa_opt['social_icons']['telegram']) {
        $share .=
        '<a href="https://telegram.me/share/?url=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on Telegram', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 50 50" width="16" height="16" fill="currentColor"><path d="M25,2c12.703,0,23,10.297,23,23S37.703,48,25,48S2,37.703,2,25S12.297,2,25,2z M32.934,34.375 c0.423-1.298,2.405-14.234,2.65-16.783c0.074-0.772-0.17-1.285-0.648-1.514c-0.578-0.278-1.434-0.139-2.427,0.219 c-1.362,0.491-18.774,7.884-19.78,8.312c-0.954,0.405-1.856,0.847-1.856,1.487c0,0.45,0.267,0.703,1.003,0.966 c0.766,0.273,2.695,0.858,3.834,1.172c1.097,0.303,2.346,0.04,3.046-0.395c0.742-0.461,9.305-6.191,9.92-6.693 c0.614-0.502,1.104,0.141,0.602,0.644c-0.502,0.502-6.38,6.207-7.155,6.997c-0.941,0.959-0.273,1.953,0.358,2.351 c0.721,0.454,5.906,3.932,6.687,4.49c0.781,0.558,1.573,0.811,2.298,0.811C32.191,36.439,32.573,35.484,32.934,34.375z"/></svg>' .
        '</a>';
    }
    
    /**
     * WhatsApp
     */
    if (isset($nasa_opt['social_icons']['whatsapp']) && $nasa_opt['social_icons']['whatsapp']) {
        $share .=
        '<a href="https://api.whatsapp.com/send?text=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on WhatsApp', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 24 24" width="17" height="17" fill="currentColor"><path d="M 12.011719 2 C 6.5057187 2 2.0234844 6.478375 2.0214844 11.984375 C 2.0204844 13.744375 2.4814687 15.462563 3.3554688 16.976562 L 2 22 L 7.2324219 20.763672 C 8.6914219 21.559672 10.333859 21.977516 12.005859 21.978516 L 12.009766 21.978516 C 17.514766 21.978516 21.995047 17.499141 21.998047 11.994141 C 22.000047 9.3251406 20.962172 6.8157344 19.076172 4.9277344 C 17.190172 3.0407344 14.683719 2.001 12.011719 2 z M 12.009766 4 C 14.145766 4.001 16.153109 4.8337969 17.662109 6.3417969 C 19.171109 7.8517969 20.000047 9.8581875 19.998047 11.992188 C 19.996047 16.396187 16.413812 19.978516 12.007812 19.978516 C 10.674812 19.977516 9.3544062 19.642812 8.1914062 19.007812 L 7.5175781 18.640625 L 6.7734375 18.816406 L 4.8046875 19.28125 L 5.2851562 17.496094 L 5.5019531 16.695312 L 5.0878906 15.976562 C 4.3898906 14.768562 4.0204844 13.387375 4.0214844 11.984375 C 4.0234844 7.582375 7.6067656 4 12.009766 4 z M 8.4765625 7.375 C 8.3095625 7.375 8.0395469 7.4375 7.8105469 7.6875 C 7.5815469 7.9365 6.9355469 8.5395781 6.9355469 9.7675781 C 6.9355469 10.995578 7.8300781 12.182609 7.9550781 12.349609 C 8.0790781 12.515609 9.68175 15.115234 12.21875 16.115234 C 14.32675 16.946234 14.754891 16.782234 15.212891 16.740234 C 15.670891 16.699234 16.690438 16.137687 16.898438 15.554688 C 17.106437 14.971687 17.106922 14.470187 17.044922 14.367188 C 16.982922 14.263188 16.816406 14.201172 16.566406 14.076172 C 16.317406 13.951172 15.090328 13.348625 14.861328 13.265625 C 14.632328 13.182625 14.464828 13.140625 14.298828 13.390625 C 14.132828 13.640625 13.655766 14.201187 13.509766 14.367188 C 13.363766 14.534188 13.21875 14.556641 12.96875 14.431641 C 12.71875 14.305641 11.914938 14.041406 10.960938 13.191406 C 10.218937 12.530406 9.7182656 11.714844 9.5722656 11.464844 C 9.4272656 11.215844 9.5585938 11.079078 9.6835938 10.955078 C 9.7955938 10.843078 9.9316406 10.663578 10.056641 10.517578 C 10.180641 10.371578 10.223641 10.267562 10.306641 10.101562 C 10.389641 9.9355625 10.347156 9.7890625 10.285156 9.6640625 C 10.223156 9.5390625 9.737625 8.3065 9.515625 7.8125 C 9.328625 7.3975 9.131125 7.3878594 8.953125 7.3808594 C 8.808125 7.3748594 8.6425625 7.375 8.4765625 7.375 z"/></svg>' .
        '</a>';
    }
    
    /**
     * Viber
     */
    if (isset($nasa_opt['social_icons']['viber']) && $nasa_opt['social_icons']['viber']) {
        $share .=
        '<a href="viber://forward?text=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on Viber', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 50 50" width="16" height="16" fill="currentColor"><path d="M 24.425781 3 C 23.0625 3.007813 21.695313 3.089844 20.316406 3.257813 C 17.679688 3.582031 15.066406 4.121094 12.558594 5.273438 C 8.570313 7.105469 5.742188 10.214844 4.921875 14.734375 C 4.574219 16.640625 4.292969 18.574219 4.132813 20.519531 C 3.824219 24.296875 4.015625 28.085938 5.085938 31.808594 C 5.929688 34.742188 7.484375 37.378906 10.207031 39.089844 C 11.359375 39.8125 12.878906 40.164063 13.671875 40.53125 C 13.894531 40.636719 13.949219 40.699219 13.960938 40.714844 C 13.972656 40.726563 14.003906 40.753906 14 40.988281 C 13.972656 43.378906 14 48.003906 14 48.003906 L 14.003906 49 L 15.789063 49 L 16.078125 48.71875 C 16.078125 48.71875 20.613281 44.355469 22.253906 42.558594 C 22.550781 42.238281 22.703125 42.058594 22.734375 42.039063 C 22.761719 42.019531 22.714844 42.007813 23.019531 42 C 25.171875 41.957031 27.320313 41.875 29.46875 41.757813 C 32.300781 41.601563 35.1875 41.332031 37.964844 40.171875 C 40.382813 39.160156 42.402344 37.507813 43.625 35.03125 C 44.875 32.492188 45.542969 29.800781 45.792969 27.015625 C 46.207031 22.378906 46.0625 17.734375 44.78125 13.15625 C 44.027344 10.472656 42.511719 8.203125 40.1875 6.601563 C 37.40625 4.6875 34.269531 3.96875 31.199219 3.511719 C 29.40625 3.246094 27.601563 3.070313 25.789063 3.015625 C 25.335938 3.003906 24.882813 2.996094 24.425781 3 Z M 25.734375 5.015625 C 27.457031 5.0625 29.179688 5.230469 30.90625 5.488281 C 33.867188 5.929688 36.660156 6.601563 39.054688 8.25 C 40.996094 9.585938 42.207031 11.390625 42.855469 13.691406 C 44.050781 17.972656 44.203125 22.359375 43.800781 26.839844 C 43.570313 29.421875 42.957031 31.855469 41.828125 34.148438 C 40.832031 36.171875 39.277344 37.457031 37.191406 38.328125 C 34.769531 39.339844 32.136719 39.609375 29.363281 39.761719 C 27.238281 39.878906 25.109375 39.957031 22.980469 40 C 22.445313 40.011719 21.921875 40.152344 21.550781 40.425781 C 21.179688 40.699219 21.011719 40.953125 20.78125 41.203125 C 19.609375 42.484375 17.273438 44.738281 16 45.972656 C 15.992188 44.480469 15.980469 42.675781 16 41.011719 C 16.007813 40.5 15.890625 39.976563 15.597656 39.5625 C 15.304688 39.148438 14.902344 38.898438 14.515625 38.71875 C 13.386719 38.195313 11.910156 37.796875 11.269531 37.394531 C 9.03125 35.988281 7.761719 33.878906 7.007813 31.253906 C 6.019531 27.820313 5.832031 24.285156 6.125 20.6875 C 6.28125 18.820313 6.550781 16.949219 6.890625 15.09375 C 7.601563 11.183594 9.835938 8.722656 13.390625 7.089844 C 15.636719 6.058594 18.035156 5.550781 20.5625 5.242188 C 22.285156 5.03125 24.007813 4.964844 25.734375 5.015625 Z M 26.15625 10 C 25.332031 10 24.53125 10.09375 23.753906 10.265625 C 23.21875 10.390625 22.878906 10.925781 23 11.464844 C 23.121094 12.003906 23.660156 12.339844 24.199219 12.21875 C 24.828125 12.074219 25.484375 12 26.15625 12 C 31.039063 12 34.976563 15.9375 34.976563 20.816406 C 34.976563 21.492188 34.902344 22.148438 34.757813 22.78125 C 34.636719 23.316406 34.972656 23.855469 35.511719 23.976563 C 36.050781 24.097656 36.585938 23.757813 36.707031 23.21875 C 36.882813 22.445313 36.976563 21.644531 36.976563 20.816406 C 36.976563 14.855469 32.121094 10 26.15625 10 Z M 16.179688 12.003906 C 16.015625 11.996094 15.847656 12.007813 15.671875 12.046875 C 13.855469 12.449219 12.050781 13.765625 12 16.117188 C 12.050781 16.445313 12.046875 16.796875 12.167969 17.09375 C 12.761719 18.546875 13.277344 20.046875 14.019531 21.421875 C 17.632813 28.101563 23.097656 32.746094 30.0625 35.695313 C 30.894531 36.046875 31.753906 36.121094 32.59375 35.769531 C 33.75 35.289063 34.730469 34.546875 35.382813 33.480469 C 36.277344 32.015625 36.289063 31 34.816406 29.917969 C 33.851563 29.207031 32.902344 28.476563 31.925781 27.78125 C 30.4375 26.726563 28.828125 26.542969 27.71875 28.394531 C 27.660156 28.488281 27.574219 28.566406 27.5 28.644531 C 26.929688 29.25 26.230469 29.398438 25.488281 29.09375 C 22.671875 27.933594 20.496094 26.0625 19.183594 23.277344 C 18.410156 21.640625 18.621094 20.820313 20.066406 19.730469 C 20.210938 19.625 20.347656 19.511719 20.480469 19.390625 C 21.113281 18.8125 21.28125 18.125 20.90625 17.347656 C 20.058594 15.574219 18.929688 13.992188 17.5 12.628906 C 17.113281 12.261719 16.671875 12.03125 16.179688 12.003906 Z M 26.140625 13 C 25.699219 13 25.261719 13.035156 24.832031 13.109375 C 24.46875 13.15625 24.160156 13.398438 24.027344 13.738281 C 23.894531 14.082031 23.960938 14.46875 24.195313 14.75 C 24.433594 15.027344 24.808594 15.15625 25.167969 15.078125 C 25.480469 15.027344 25.808594 15 26.140625 15 C 29.390625 15 32 17.609375 32 20.859375 C 32 21.191406 31.972656 21.519531 31.921875 21.832031 C 31.84375 22.191406 31.972656 22.566406 32.25 22.804688 C 32.53125 23.039063 32.917969 23.105469 33.261719 22.972656 C 33.601563 22.839844 33.84375 22.53125 33.890625 22.167969 C 33.964844 21.738281 34 21.300781 34 20.859375 C 34 16.53125 30.46875 13 26.140625 13 Z M 26 16 C 25.640625 15.996094 25.304688 16.183594 25.121094 16.496094 C 24.941406 16.808594 24.941406 17.191406 25.121094 17.503906 C 25.304688 17.816406 25.640625 18.003906 26 18 C 27.667969 18 29 19.332031 29 21 C 28.996094 21.359375 29.183594 21.695313 29.496094 21.878906 C 29.808594 22.058594 30.191406 22.058594 30.503906 21.878906 C 30.816406 21.695313 31.003906 21.359375 31 21 C 31 18.25 28.75 16 26 16 Z"/></svg>' .
        '</a>';
    }
    
    /**
     * VK
     */
    if (isset($nasa_opt['social_icons']['vk']) && $nasa_opt['social_icons']['vk']) {
        $share .=
        '<a href="https://vk.com/share.php?url=' . esc_url($permalink) . '&amp;title=' . esc_attr($post_title) . '&amp;image=' . esc_attr($featured_image_2) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on VK', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 48 48" width="18" height="18" fill="currentColor"><path d="M45.763,35.202c-1.797-3.234-6.426-7.12-8.337-8.811c-0.523-0.463-0.579-1.264-0.103-1.776 c3.647-3.919,6.564-8.422,7.568-11.143C45.334,12.27,44.417,11,43.125,11l-3.753,0c-1.237,0-1.961,0.444-2.306,1.151 c-3.031,6.211-5.631,8.899-7.451,10.47c-1.019,0.88-2.608,0.151-2.608-1.188c0-2.58,0-5.915,0-8.28 c0-1.147-0.938-2.075-2.095-2.075L18.056,11c-0.863,0-1.356,0.977-0.838,1.662l1.132,1.625c0.426,0.563,0.656,1.248,0.656,1.951 L19,23.556c0,1.273-1.543,1.895-2.459,1.003c-3.099-3.018-5.788-9.181-6.756-12.128C9.505,11.578,8.706,11.002,7.8,11l-3.697-0.009 c-1.387,0-2.401,1.315-2.024,2.639c3.378,11.857,10.309,23.137,22.661,24.36c1.217,0.12,2.267-0.86,2.267-2.073l0-3.846 c0-1.103,0.865-2.051,1.977-2.079c0.039-0.001,0.078-0.001,0.117-0.001c3.267,0,6.926,4.755,8.206,6.979 c0.368,0.64,1.056,1.03,1.8,1.03l4.973,0C45.531,38,46.462,36.461,45.763,35.202z"/></svg>' .
        '</a>';
    }
    
    /**
     * OK
     */
    if (isset($nasa_opt['social_icons']['ok']) && $nasa_opt['social_icons']['ok']) {
        $share .=
        '<a href="https://connect.ok.ru/offer?url=' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Share on Odnoklassniki', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 48 48" width="17" height="17" fill="currentColor"><path d="M 24 2 C 17.925 2 13 6.925 13 13 C 13 19.075 17.925 24 24 24 C 30.075 24 35 19.075 35 13 C 35 6.925 30.075 2 24 2 z M 24 8.9472656 C 26.238 8.9472656 28.052734 10.761 28.052734 13 C 28.052734 15.238 26.238 17.052734 24 17.052734 C 21.762 17.052734 19.947266 15.239 19.947266 13 C 19.947266 10.762 21.761 8.9472656 24 8.9472656 z M 33.185547 24.046875 C 32.402922 24.009469 31.6245 24.203187 30.9375 24.617188 C 26.7875 27.116187 21.2115 27.116187 17.0625 24.617188 C 15.1725 23.478188 12.710266 24.090469 11.572266 25.980469 C 11.021266 26.896469 10.858234 27.970813 11.115234 29.007812 C 11.373234 30.044812 12.019547 30.920703 12.935547 31.470703 C 14.396547 32.350703 15.959516 33.049594 17.603516 33.558594 L 12.009766 39.339844 C 11.300766 40.138844 10.942859 41.165422 11.005859 42.232422 C 11.068859 43.299422 11.542797 44.276328 12.341797 44.986328 C 13.105797 45.665328 14.060812 45.998047 15.007812 45.998047 C 16.103813 45.998047 17.189938 45.552547 17.960938 44.685547 L 24 38.443359 L 30.013672 44.652344 C 30.771672 45.506344 31.861906 45.994141 33.003906 45.994141 C 33.982906 45.994141 34.926156 45.635375 35.660156 44.984375 C 37.308156 43.519375 37.458844 40.986641 35.964844 39.306641 L 30.396484 33.558594 C 32.040484 33.048594 33.605406 32.34875 35.066406 31.46875 C 35.981406 30.91775 36.627766 30.044813 36.884766 29.007812 C 37.141766 27.970813 36.978734 26.895469 36.427734 25.980469 C 35.876734 25.065469 35.003797 24.419109 33.966797 24.162109 C 33.707797 24.097609 33.446422 24.059344 33.185547 24.046875 z"/></svg>' .
        '</a>';
    }
    
    /**
     * Email
     */
    if (isset($nasa_opt['social_icons']['email']) && $nasa_opt['social_icons']['email']) {
        $share .=
        '<a href="mailto:enter-your-mail@domain-here.com?subject=' . esc_attr($post_title) . '&amp;body=Check%20this%20out:%20' . esc_url($permalink) . '" target="_blank" class="icon nasa-tip" title="' . esc_attr__('Email to your friends', 'nasa-core') . '" rel="nofollow">' .
            '<svg viewBox="0 0 24 24" width="17" height="17" fill="currentColor"><path d="M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4ZM5,6H19a1,1,0,0,1,1,1l-8,4.88L4,7A1,1,0,0,1,5,6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.28l7.48,4.57a1,1,0,0,0,1,0L20,9.28Z"/></svg>' .
        '</a>';
    }

    $share_content = apply_filters('nasa_share_content', $share);
    
    $share_wrap_end = '</div>';

    return $share_content ? $share_wrap_start . $share_content . $share_wrap_end : '';
}

/**
 * Shortcode [nasa_follow ...]
 * 
 * @global type $nasa_opt
 * @param type $atts
 * @param string $content
 * @return string
 */
function nasa_sc_follow($atts = array(), $content = null) {
    extract(shortcode_atts(array(
        'title' => '',
        'twitter' => '',
        'facebook' => '',
        'vk' => '',
        'pinterest' => '',
        'email' => '',
        'instagram' => '',
        'rss' => '',
        'linkedin' => '',
        'youtube' => '',
        'flickr' => '',
        'telegram' => '',
        'whatsapp' => '',
        'tiktok' => '',
        'tumblr' => '',
        'weibo' => '',
        'snapchat' => '',
        'amazon' => '',
        'vimeo' => '',
        'github' => '',
        'dribbble' => '',
        'behance' => '',
        'soundcloud' => '',
        'spotify' => '',
        'ok' => '',
        'discord' => '',
        'tip' => '',
        'el_class' => ''
    ), $atts));
    
    global $nasa_opt;
    $facebook   = $facebook ? $facebook : (isset($nasa_opt['facebook_url_follow']) ? $nasa_opt['facebook_url_follow'] : '');
    $twitter    = $twitter ? $twitter : (isset($nasa_opt['twitter_url_follow']) ? $nasa_opt['twitter_url_follow'] : '');
    $email      = $email ? $email : (isset($nasa_opt['email_url_follow']) ? $nasa_opt['email_url_follow'] : '');
    $pinterest  = $pinterest ? $pinterest : (isset($nasa_opt['pinterest_url_follow']) ? $nasa_opt['pinterest_url_follow'] : '');
    $instagram  = $instagram ? $instagram : (isset($nasa_opt['instagram_url']) ? $nasa_opt['instagram_url'] : '');
    $rss        = $rss ? $rss : (isset($nasa_opt['rss_url_follow']) ? $nasa_opt['rss_url_follow'] : '');
    $linkedin   = $linkedin ? $linkedin : (isset($nasa_opt['linkedin_url_follow']) ? $nasa_opt['linkedin_url_follow'] : '');
    $youtube    = $youtube ? $youtube : (isset($nasa_opt['youtube_url_follow']) ? $nasa_opt['youtube_url_follow'] : '');
    $flickr     = $flickr ? $flickr : (isset($nasa_opt['flickr_url_follow']) ? $nasa_opt['flickr_url_follow'] : '');
    $telegram   = $telegram ? $telegram : (isset($nasa_opt['telegram_url_follow']) ? $nasa_opt['telegram_url_follow'] : '');
    $whatsapp   = $whatsapp ? $whatsapp : (isset($nasa_opt['whatsapp_url_follow']) ? $nasa_opt['whatsapp_url_follow'] : '');
    $tiktok     = $tiktok ? $tiktok : (isset($nasa_opt['tiktok_url_follow']) ? $nasa_opt['tiktok_url_follow'] : '');
    $amazon     = $amazon ? $amazon : (isset($nasa_opt['amazon_url_follow']) ? $nasa_opt['amazon_url_follow'] : '');
    $tumblr     = $tumblr ? $tumblr : (isset($nasa_opt['tumblr_url_follow']) ? $nasa_opt['tumblr_url_follow'] : '');
    $vk         = $vk ? $vk : (isset($nasa_opt['vk_url_follow']) ? $nasa_opt['vk_url_follow'] : '');
    $weibo      = $weibo ? $weibo : (isset($nasa_opt['weibo_url_follow']) ? $nasa_opt['weibo_url_follow'] : '');
    $snapchat   = $snapchat ? $snapchat : (isset($nasa_opt['snapchat_url_follow']) ? $nasa_opt['snapchat_url_follow'] : '');
    
    $vimeo      = $vimeo ? $vimeo : (isset($nasa_opt['vimeo_url_follow']) ? $nasa_opt['vimeo_url_follow'] : '');
    $github     = $github ? $github : (isset($nasa_opt['github_url_follow']) ? $nasa_opt['github_url_follow'] : '');
    $dribbble   = $dribbble ? $dribbble : (isset($nasa_opt['dribbble_url_follow']) ? $nasa_opt['dribbble_url_follow'] : '');
    $behance    = $behance ? $behance : (isset($nasa_opt['behance_url_follow']) ? $nasa_opt['behance_url_follow'] : '');
    $soundcloud = $soundcloud ? $soundcloud : (isset($nasa_opt['soundcloud_url_follow']) ? $nasa_opt['soundcloud_url_follow'] : '');
    $spotify    = $spotify ? $spotify : (isset($nasa_opt['spotify_url_follow']) ? $nasa_opt['spotify_url_follow'] : '');
    $ok         = $ok ? $ok : (isset($nasa_opt['ok_url_follow']) ? $nasa_opt['ok_url_follow'] : '');
    $discord    = $discord ? $discord : (isset($nasa_opt['discord_url_follow']) ? $nasa_opt['discord_url_follow'] : '');
    
    $follow_wrap_start = '<div class="ns-social social-icons nasa-follow' . ($el_class ? ' ' . esc_attr($el_class) : '') . '">';
    $follow_wrap_start .= $title ? '<div class="nasa-follow-title">' . $title . '</div>' : '';
    $follow_wrap_start .= '<div class="follow-icon nasa-iflex flex-wrap">';
    
    $follow = '';
    
    $class_tip = 'nasa-tip';
    if (isset($tip)) {
        $class_tip .= $tip == 'left' ? ' nasa-tip-left' : '';
        $class_tip .= $tip == 'right' ? ' nasa-tip-right' : '';
        $class_tip .= $tip == 'bottom' ? ' nasa-tip-bottom' : '';
    }

    /**
     * Twitter
     */
    if ($twitter) {
        $follow .= '<a href="' . esc_url($twitter) . '" target="_blank" class="icon icon_twitter ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on X', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 24 24" with="14" height="14" aria-hidden="true" fill="currentColor"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg></a>';
    }

    /**
     * FaceBook
     */
    if ($facebook) {
        $follow .= '<a href="' . esc_url($facebook) . '" target="_blank" class="icon icon_facebook ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Facebook', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 32 32" with="16" height="16" fill="currentColor"><path d="M 19.253906 2 C 15.311906 2 13 4.0821719 13 8.8261719 L 13 13 L 8 13 L 8 18 L 13 18 L 13 30 L 18 30 L 18 18 L 22 18 L 23 13 L 18 13 L 18 9.671875 C 18 7.884875 18.582766 7 20.259766 7 L 23 7 L 23 2.2050781 C 22.526 2.1410781 21.144906 2 19.253906 2 z"/></svg></a>';
    }
    
    /**
     * VK
     */
    if ($vk) {
        $follow .= '<a href="' . esc_url($vk) . '" target="_blank" class="icon icon_vk ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on VK', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="16" height="16" fill="currentColor"><path d="M45.763,35.202c-1.797-3.234-6.426-7.12-8.337-8.811c-0.523-0.463-0.579-1.264-0.103-1.776 c3.647-3.919,6.564-8.422,7.568-11.143C45.334,12.27,44.417,11,43.125,11l-3.753,0c-1.237,0-1.961,0.444-2.306,1.151 c-3.031,6.211-5.631,8.899-7.451,10.47c-1.019,0.88-2.608,0.151-2.608-1.188c0-2.58,0-5.915,0-8.28 c0-1.147-0.938-2.075-2.095-2.075L18.056,11c-0.863,0-1.356,0.977-0.838,1.662l1.132,1.625c0.426,0.563,0.656,1.248,0.656,1.951 L19,23.556c0,1.273-1.543,1.895-2.459,1.003c-3.099-3.018-5.788-9.181-6.756-12.128C9.505,11.578,8.706,11.002,7.8,11l-3.697-0.009 c-1.387,0-2.401,1.315-2.024,2.639c3.378,11.857,10.309,23.137,22.661,24.36c1.217,0.12,2.267-0.86,2.267-2.073l0-3.846 c0-1.103,0.865-2.051,1.977-2.079c0.039-0.001,0.078-0.001,0.117-0.001c3.267,0,6.926,4.755,8.206,6.979 c0.368,0.64,1.056,1.03,1.8,1.03l4.973,0C45.531,38,46.462,36.461,45.763,35.202z"/></svg></a>';
    }

    /**
     * Email
     */
    if ($email) {
        $follow .= '<a href="mailto:' . $email . '" target="_blank" class="icon icon_email ' . esc_attr($class_tip) . '" title="' . esc_attr__('Send us an email', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4ZM5,6H19a1,1,0,0,1,1,1l-8,4.88L4,7A1,1,0,0,1,5,6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.28l7.48,4.57a1,1,0,0,0,1,0L20,9.28Z"/></svg></a>';
    }

    /**
     * Pinterest
     */
    if ($pinterest) {
        $follow .= '<a href="' . esc_url($pinterest) . '" target="_blank" class="icon icon_pintrest ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Pinterest', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 16 16" width="16" height="16" fill="currentColor"><path d="M 7.5 1 C 3.910156 1 1 3.910156 1 7.5 C 1 10.253906 2.714844 12.605469 5.132813 13.554688 C 5.074219 13.039063 5.023438 12.25 5.152344 11.6875 C 5.273438 11.183594 5.914063 8.457031 5.914063 8.457031 C 5.914063 8.457031 5.722656 8.066406 5.722656 7.492188 C 5.722656 6.589844 6.246094 5.914063 6.898438 5.914063 C 7.453125 5.914063 7.71875 6.332031 7.71875 6.828125 C 7.71875 7.386719 7.363281 8.222656 7.183594 8.992188 C 7.027344 9.640625 7.507813 10.167969 8.144531 10.167969 C 9.300781 10.167969 10.1875 8.949219 10.1875 7.191406 C 10.1875 5.636719 9.070313 4.546875 7.472656 4.546875 C 5.625 4.546875 4.539063 5.933594 4.539063 7.367188 C 4.539063 7.925781 4.753906 8.527344 5.023438 8.851563 C 5.074219 8.917969 5.082031 8.972656 5.066406 9.039063 C 5.019531 9.242188 4.90625 9.6875 4.886719 9.777344 C 4.859375 9.894531 4.792969 9.921875 4.667969 9.863281 C 3.855469 9.484375 3.347656 8.296875 3.347656 7.34375 C 3.347656 5.292969 4.839844 3.410156 7.644531 3.410156 C 9.898438 3.410156 11.652344 5.015625 11.652344 7.164063 C 11.652344 9.402344 10.238281 11.207031 8.277344 11.207031 C 7.617188 11.207031 7 10.863281 6.789063 10.460938 C 6.789063 10.460938 6.460938 11.703125 6.382813 12.007813 C 6.234375 12.570313 5.839844 13.277344 5.574219 13.710938 C 6.183594 13.898438 6.828125 14 7.5 14 C 11.089844 14 14 11.089844 14 7.5 C 14 3.910156 11.089844 1 7.5 1 Z"/></svg></a>';
    }

    /**
     * Instagram
     */
    if ($instagram) {
        $follow .= '<a href="' . esc_url($instagram) . '" target="_blank" class="icon icon_instagram ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Instagram', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="18" height="18" fill="currentColor"><path d="M 16.5 5 C 10.16639 5 5 10.16639 5 16.5 L 5 31.5 C 5 37.832757 10.166209 43 16.5 43 L 31.5 43 C 37.832938 43 43 37.832938 43 31.5 L 43 16.5 C 43 10.166209 37.832757 5 31.5 5 L 16.5 5 z M 16.5 8 L 31.5 8 C 36.211243 8 40 11.787791 40 16.5 L 40 31.5 C 40 36.211062 36.211062 40 31.5 40 L 16.5 40 C 11.787791 40 8 36.211243 8 31.5 L 8 16.5 C 8 11.78761 11.78761 8 16.5 8 z M 34 12 C 32.895 12 32 12.895 32 14 C 32 15.105 32.895 16 34 16 C 35.105 16 36 15.105 36 14 C 36 12.895 35.105 12 34 12 z M 24 14 C 18.495178 14 14 18.495178 14 24 C 14 29.504822 18.495178 34 24 34 C 29.504822 34 34 29.504822 34 24 C 34 18.495178 29.504822 14 24 14 z M 24 17 C 27.883178 17 31 20.116822 31 24 C 31 27.883178 27.883178 31 24 31 C 20.116822 31 17 27.883178 17 24 C 17 20.116822 20.116822 17 24 17 z"/></svg></a>';
    }

    /**
     * Rss
     */
    if ($rss) {
        $follow .= '<a href="' . esc_url($rss) . '" target="_blank" class="icon icon_rss ' . esc_attr($class_tip) . '" title="' . esc_attr__('Subscribe to RSS', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 32 32" width="16" height="16" fill="currentColor"><path d="M 5 5 L 5 9 C 14.93 9 23 17.07 23 27 L 27 27 C 27 14.85 17.15 5 5 5 z M 5 12 L 5 16 C 11.07 16 16 20.93 16 27 L 20 27 C 20 18.72 13.28 12 5 12 z M 8 21 A 3 3 0 0 0 8 27 A 3 3 0 0 0 8 21 z"/></svg></a>';
    }

    /**
     * LinkedIn
     */
    if ($linkedin) {
        $follow .= '<a href="' . esc_url($linkedin) . '" target="_blank" class="icon icon_linkedin ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on LinkedIn', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 30 30" width="16" height="16" fill="currentColor"><path d="M9,25H4V10h5V25z M6.501,8C5.118,8,4,6.879,4,5.499S5.12,3,6.501,3C7.879,3,9,4.121,9,5.499C9,6.879,7.879,8,6.501,8z M27,25h-4.807v-7.3c0-1.741-0.033-3.98-2.499-3.98c-2.503,0-2.888,1.896-2.888,3.854V25H12V9.989h4.614v2.051h0.065 c0.642-1.18,2.211-2.424,4.551-2.424c4.87,0,5.77,3.109,5.77,7.151C27,16.767,27,25,27,25z"/></svg></a>';
    }

    /**
     * YouTube
     */
    if ($youtube) {
        $follow .= '<a href="' . esc_url($youtube) . '" target="_blank" class="icon icon_youtube ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on YouTube', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M21.582,6.186c-0.23-0.86-0.908-1.538-1.768-1.768C18.254,4,12,4,12,4S5.746,4,4.186,4.418 c-0.86,0.23-1.538,0.908-1.768,1.768C2,7.746,2,12,2,12s0,4.254,0.418,5.814c0.23,0.86,0.908,1.538,1.768,1.768 C5.746,20,12,20,12,20s6.254,0,7.814-0.418c0.861-0.23,1.538-0.908,1.768-1.768C22,16.254,22,12,22,12S22,7.746,21.582,6.186z M10,14.598V9.402c0-0.385,0.417-0.625,0.75-0.433l4.5,2.598c0.333,0.192,0.333,0.674,0,0.866l-4.5,2.598 C10.417,15.224,10,14.983,10,14.598z"/></svg></a>';
    }

    /**
     * Flickr
     */
    if ($flickr) {
        $follow .= '<a href="' . esc_url($flickr) . '" target="_blank" class="icon icon_flickr ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Flickr', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="16" height="16" fill="currentColor"><path d="M36.5,6h-25C8.468,6,6,8.467,6,11.5v25c0,3.033,2.468,5.5,5.5,5.5h25c3.032,0,5.5-2.467,5.5-5.5v-25 C42,8.467,39.532,6,36.5,6z M16.5,29c-3.038,0-5.5-2.462-5.5-5.5c0-3.038,2.462-5.5,5.5-5.5s5.5,2.462,5.5,5.5 C22,26.538,19.538,29,16.5,29z M31.5,29c-3.038,0-5.5-2.462-5.5-5.5c0-3.038,2.462-5.5,5.5-5.5s5.5,2.462,5.5,5.5 C37,26.538,34.538,29,31.5,29z"/></svg></a>';
    }
    
    /**
     * Tumblr
     */
    if ($tumblr) {
        $follow .= '<a href="' . esc_url($tumblr) . '" target="_blank" class="icon icon_tumblr ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Tumblr', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 50 50" width="17" height="17" fill="currentColor"><path d="M17.594,23.641h-2.681c-0.692,0-1.253-0.561-1.253-1.253v-4.613c0-0.758,0.475-1.428,1.189-1.681 c1.738-0.614,4.822-2.439,5.33-7.712C20.255,7.605,20.892,7,21.674,7h4.993c0.681,0,1.234,0.552,1.234,1.234v7.267h5.053 c0.692,0,1.253,0.561,1.253,1.253v5.635c0,0.692-0.561,1.253-1.253,1.253h-5.053v8.142c0,1.85,0.893,2.559,1.745,2.559 c0.67,0,1.828-0.306,2.685-0.538c0.712-0.193,1.196,0.026,1.444,0.747s1.598,4.557,1.598,4.557c0.246,0.703-0.006,1.477-0.615,1.906 c-1.152,0.812-3.319,1.924-6.547,1.924c-5.014,0-10.617-2.228-10.617-10.542C17.594,30.745,17.594,23.641,17.594,23.641z"/></svg></a>';
    }

    /**
     * Telegram
     */
    if ($telegram) {
        $follow .= '<a href="' . esc_url($telegram) . '" target="_blank" class="icon icon_telegram ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Telegram', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 50 50" width="15" height="15" fill="currentColor"><path d="M25,2c12.703,0,23,10.297,23,23S37.703,48,25,48S2,37.703,2,25S12.297,2,25,2z M32.934,34.375 c0.423-1.298,2.405-14.234,2.65-16.783c0.074-0.772-0.17-1.285-0.648-1.514c-0.578-0.278-1.434-0.139-2.427,0.219 c-1.362,0.491-18.774,7.884-19.78,8.312c-0.954,0.405-1.856,0.847-1.856,1.487c0,0.45,0.267,0.703,1.003,0.966 c0.766,0.273,2.695,0.858,3.834,1.172c1.097,0.303,2.346,0.04,3.046-0.395c0.742-0.461,9.305-6.191,9.92-6.693 c0.614-0.502,1.104,0.141,0.602,0.644c-0.502,0.502-6.38,6.207-7.155,6.997c-0.941,0.959-0.273,1.953,0.358,2.351 c0.721,0.454,5.906,3.932,6.687,4.49c0.781,0.558,1.573,0.811,2.298,0.811C32.191,36.439,32.573,35.484,32.934,34.375z"/></svg></a>';
    }

    /**
     * Whatsapp
     */
    if ($whatsapp) {
        $follow .= '<a href="' . esc_url($whatsapp) . '" target="_blank" class="icon icon_whatsapp ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Whatsapp', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 24 24" width="17" height="17" fill="currentColor"><path d="M 12.011719 2 C 6.5057187 2 2.0234844 6.478375 2.0214844 11.984375 C 2.0204844 13.744375 2.4814687 15.462563 3.3554688 16.976562 L 2 22 L 7.2324219 20.763672 C 8.6914219 21.559672 10.333859 21.977516 12.005859 21.978516 L 12.009766 21.978516 C 17.514766 21.978516 21.995047 17.499141 21.998047 11.994141 C 22.000047 9.3251406 20.962172 6.8157344 19.076172 4.9277344 C 17.190172 3.0407344 14.683719 2.001 12.011719 2 z M 12.009766 4 C 14.145766 4.001 16.153109 4.8337969 17.662109 6.3417969 C 19.171109 7.8517969 20.000047 9.8581875 19.998047 11.992188 C 19.996047 16.396187 16.413812 19.978516 12.007812 19.978516 C 10.674812 19.977516 9.3544062 19.642812 8.1914062 19.007812 L 7.5175781 18.640625 L 6.7734375 18.816406 L 4.8046875 19.28125 L 5.2851562 17.496094 L 5.5019531 16.695312 L 5.0878906 15.976562 C 4.3898906 14.768562 4.0204844 13.387375 4.0214844 11.984375 C 4.0234844 7.582375 7.6067656 4 12.009766 4 z M 8.4765625 7.375 C 8.3095625 7.375 8.0395469 7.4375 7.8105469 7.6875 C 7.5815469 7.9365 6.9355469 8.5395781 6.9355469 9.7675781 C 6.9355469 10.995578 7.8300781 12.182609 7.9550781 12.349609 C 8.0790781 12.515609 9.68175 15.115234 12.21875 16.115234 C 14.32675 16.946234 14.754891 16.782234 15.212891 16.740234 C 15.670891 16.699234 16.690438 16.137687 16.898438 15.554688 C 17.106437 14.971687 17.106922 14.470187 17.044922 14.367188 C 16.982922 14.263188 16.816406 14.201172 16.566406 14.076172 C 16.317406 13.951172 15.090328 13.348625 14.861328 13.265625 C 14.632328 13.182625 14.464828 13.140625 14.298828 13.390625 C 14.132828 13.640625 13.655766 14.201187 13.509766 14.367188 C 13.363766 14.534188 13.21875 14.556641 12.96875 14.431641 C 12.71875 14.305641 11.914938 14.041406 10.960938 13.191406 C 10.218937 12.530406 9.7182656 11.714844 9.5722656 11.464844 C 9.4272656 11.215844 9.5585938 11.079078 9.6835938 10.955078 C 9.7955938 10.843078 9.9316406 10.663578 10.056641 10.517578 C 10.180641 10.371578 10.223641 10.267562 10.306641 10.101562 C 10.389641 9.9355625 10.347156 9.7890625 10.285156 9.6640625 C 10.223156 9.5390625 9.737625 8.3065 9.515625 7.8125 C 9.328625 7.3975 9.131125 7.3878594 8.953125 7.3808594 C 8.808125 7.3748594 8.6425625 7.375 8.4765625 7.375 z"/></svg></a>';
    }
    
    /**
     * Tiktok
     */
    if ($tiktok) {
        $follow .= '<a href="' . esc_url($tiktok) . '" target="_blank" class="icon icon_tiktok ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Tiktok', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 2859 3333" width="14" height="14" fill="currentColor"><path d="M2081 0c55 473 319 755 778 785v532c-266 26-499-61-770-225v995c0 1264-1378 1659-1932 753-356-583-138-1606 1004-1647v561c-87 14-180 36-265 65-254 86-398 247-358 531 77 544 1075 705 992-358V1h551z"/></svg></a>';
    }
    
    /**
     * Weibo
     */
    if ($weibo) {
        $follow .= '<a href="' . esc_url($weibo) . '" target="_blank" class="icon icon_weibo ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Weibo', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 50 50" width="17" height="17" fill="currentColor"><path d="M 35 6 C 34.222656 6 33.472656 6.078125 32.75 6.207031 C 32.207031 6.300781 31.84375 6.820313 31.9375 7.363281 C 32.03125 7.910156 32.550781 8.273438 33.09375 8.179688 C 33.726563 8.066406 34.359375 8 35 8 C 41.085938 8 46 12.914063 46 19 C 46 20.316406 45.757813 21.574219 45.328125 22.753906 C 45.195313 23.09375 45.253906 23.476563 45.484375 23.757813 C 45.71875 24.039063 46.082031 24.171875 46.441406 24.105469 C 46.800781 24.039063 47.09375 23.78125 47.207031 23.4375 C 47.710938 22.054688 48 20.566406 48 19 C 48 11.832031 42.167969 6 35 6 Z M 35 12 C 34.574219 12 34.171875 12.042969 33.789063 12.109375 C 33.246094 12.207031 32.878906 12.722656 32.976563 13.269531 C 33.070313 13.8125 33.589844 14.175781 34.132813 14.082031 C 34.425781 14.03125 34.714844 14 35 14 C 37.773438 14 40 16.226563 40 19 C 40 19.597656 39.890625 20.167969 39.691406 20.707031 C 39.503906 21.226563 39.773438 21.800781 40.292969 21.988281 C 40.8125 22.175781 41.386719 21.910156 41.574219 21.390625 C 41.84375 20.648438 42 19.84375 42 19 C 42 15.144531 38.855469 12 35 12 Z M 21.175781 12.40625 C 17.964844 12.34375 13.121094 14.878906 8.804688 19.113281 C 4.511719 23.40625 2 27.90625 2 31.78125 C 2 39.3125 11.628906 43.8125 21.152344 43.8125 C 33.5 43.8125 41.765625 36.699219 41.765625 31.046875 C 41.765625 27.59375 38.835938 25.707031 36.21875 24.871094 C 35.59375 24.660156 35.175781 24.558594 35.488281 23.71875 C 35.695313 23.21875 36 22.265625 36 21 C 36 19.5625 35 18.316406 33 18.09375 C 32.007813 17.984375 28 18 25.339844 19.113281 C 25.339844 19.113281 23.871094 19.746094 24.289063 18.59375 C 25.023438 16.292969 24.917969 14.40625 23.765625 13.359375 C 23.140625 12.730469 22.25 12.425781 21.175781 12.40625 Z M 20.3125 23.933594 C 28.117188 23.933594 34.441406 27.914063 34.441406 32.828125 C 34.441406 37.738281 28.117188 41.71875 20.3125 41.71875 C 12.511719 41.71875 6.1875 37.738281 6.1875 32.828125 C 6.1875 27.914063 12.511719 23.933594 20.3125 23.933594 Z M 19.265625 26.023438 C 16.246094 26.046875 13.3125 27.699219 12.039063 30.246094 C 10.46875 33.484375 11.933594 37.042969 15.699219 38.191406 C 19.464844 39.445313 23.960938 37.5625 25.53125 34.113281 C 27.097656 30.769531 25.113281 27.214844 21.347656 26.277344 C 20.660156 26.097656 19.960938 26.019531 19.265625 26.023438 Z M 20.824219 30.25 C 21.402344 30.25 21.871094 30.714844 21.871094 31.292969 C 21.871094 31.871094 21.402344 32.339844 20.824219 32.339844 C 20.246094 32.339844 19.777344 31.871094 19.777344 31.292969 C 19.777344 30.714844 20.246094 30.25 20.824219 30.25 Z M 16.417969 31.292969 C 16.746094 31.296875 17.074219 31.347656 17.382813 31.453125 C 18.722656 31.878906 19.132813 33.148438 18.308594 34.207031 C 17.589844 35.265625 15.945313 35.792969 14.707031 35.265625 C 13.476563 34.738281 13.167969 33.464844 13.886719 32.515625 C 14.425781 31.71875 15.429688 31.28125 16.417969 31.292969 Z"/></svg></a>';
    }
    
    /**
     * Snapchat
     */
    if ($snapchat) {
        $follow .= '<a href="' . esc_url($snapchat) . '" target="_blank" class="icon icon_snapchat ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Snapchat', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 16 16" width="17" height="17" fill="currentColor"><path d="M14.5,11c-0.095,0-2.165-0.024-2.464-2H12.5C13.327,9,14,8.327,14,7.5S13.327,6,12.5,6H12V5.198C12,2.996,10.495,1,8,1 S4,2.996,4,5.198V6H3.5C2.673,6,2,6.673,2,7.5S2.673,9,3.5,9h0.464c-0.299,1.976-2.369,2-2.464,2C1.224,11,1,11.224,1,11.5 c0,1.249,0.914,1.491,1.46,1.635C3,13.278,3,13.32,3,13.5C3,13.776,3.224,14,3.5,14h1.157c0.338,0,0.652,0.103,0.883,0.289 c0,0,0,0,0,0c0.406,0.327,1.162,0.716,2.46,0.716s2.054-0.389,2.46-0.716c0,0,0,0,0,0C10.691,14.103,11.005,14,11.343,14H12.5 c0.276,0,0.5-0.224,0.5-0.5c0-0.18,0-0.222,0.54-0.365C14.086,12.991,15,12.749,15,11.5C15,11.224,14.776,11,14.5,11z M13.284,12.168c-0.386,0.102-0.98,0.259-1.2,0.832h-0.741c-0.566,0-1.102,0.181-1.511,0.51C9.552,13.736,9.007,14.005,8,14.005 s-1.552-0.269-1.833-0.495C5.759,13.181,5.223,13,4.657,13H3.916c-0.219-0.572-0.814-0.729-1.2-0.832 c-0.288-0.076-0.47-0.13-0.578-0.228C3.374,11.72,5,10.833,5,8.5C5,8.224,4.776,8,4.5,8h-1C3.224,8,3,7.776,3,7.5S3.224,7,3.5,7h1 C4.776,7,5,6.776,5,6.5V5.198C5,3.519,6,2,8,2s3,1.519,3,3.198V6.5C11,6.776,11.224,7,11.5,7h1C12.776,7,13,7.224,13,7.5 S12.776,8,12.5,8h-1C11.224,8,11,8.224,11,8.5c0,2.333,1.626,3.22,2.862,3.441C13.754,12.039,13.572,12.092,13.284,12.168z"/></svg></a>';
    }
    
    /**
     * Vimeo
     */
    if ($vimeo) {
        $follow .= '<a href="' . esc_url($vimeo) . '" target="_blank" class="icon icon_vimeo ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Vimeo', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 50 50" width="17" height="17" fill="currentColor"><path d="M 40.976563 7 C 42.636719 7.042969 43.828125 7.46875 44.613281 8.300781 C 45.632813 9.382813 46.097656 11.273438 46 13.902344 C 45.796875 18.144531 42.597656 24.378906 36.976563 31.480469 C 29.804688 40.886719 25.25 42.863281 22.691406 42.863281 C 21.007813 42.863281 19.277344 40.722656 17.8125 36.839844 C 17.214844 34.589844 16.582031 32.3125 15.96875 30.109375 C 15.351563 27.886719 14.714844 25.585938 14.105469 23.289063 C 12.851563 18.90625 11.121094 14.429688 7.800781 14.429688 C 7.539063 14.429688 7.046875 14.429688 5.8125 15.066406 C 5.953125 14.953125 6.09375 14.84375 6.234375 14.730469 C 7.425781 13.789063 8.65625 12.8125 9.878906 11.703125 C 11.546875 10.257813 14.070313 8.070313 15.183594 7.992188 C 15.3125 7.980469 15.441406 7.972656 15.566406 7.972656 C 18.609375 7.972656 19.617188 11.722656 19.949219 13.96875 C 20.800781 19.445313 21.546875 22.464844 21.90625 23.914063 L 21.945313 24.070313 C 22.800781 28.089844 23.898438 32 27 32 C 28.203125 32 30.625 31.386719 33.359375 27.238281 C 35.746094 23.484375 36.292969 20.433594 36.402344 18.917969 C 36.550781 17.660156 36.605469 15.871094 35.476563 14.59375 C 34.382813 13.355469 32.78125 13.214844 31.671875 13.214844 C 31.597656 13.214844 31.523438 13.214844 31.453125 13.21875 C 33.546875 8.847656 36.472656 7 40.976563 7 M 40.976563 5 C 34.203125 5 30.464844 8.804688 28.167969 16.210938 C 29.371094 15.765625 30.578125 15.214844 31.671875 15.214844 C 33.972656 15.214844 34.738281 16.070313 34.410156 18.726563 C 34.300781 20.386719 33.644531 23.066406 31.671875 26.164063 C 29.699219 29.152344 27.984375 30 27 30 C 25.796875 30 24.882813 28.269531 23.898438 23.621094 C 23.570313 22.292969 22.804688 19.304688 21.925781 13.664063 C 21.203125 8.742188 18.878906 5.972656 15.570313 5.972656 C 15.382813 5.972656 15.191406 5.980469 15 6 C 13.46875 6.109375 11.636719 7.535156 8.570313 10.191406 C 6.378906 12.183594 4.300781 13.621094 2 15.613281 L 4.191406 18.421875 C 6.269531 16.984375 7.476563 16.429688 7.804688 16.429688 C 9.335938 16.429688 10.757813 18.863281 12.183594 23.84375 C 13.386719 28.378906 14.699219 32.914063 15.90625 37.449219 C 17.765625 42.429688 20.066406 44.863281 22.691406 44.863281 C 27.074219 44.863281 32.328125 40.882813 38.570313 32.695313 C 44.699219 24.949219 47.78125 18.535156 48 14 C 48.21875 8.027344 45.816406 5.109375 41 5 C 40.992188 5 40.984375 5 40.976563 5 Z"/></svg></a>';
    }
    
    /**
     * Github
     */
    if ($github) {
        $follow .= '<a href="' . esc_url($github) . '" target="_blank" class="icon icon_github ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Github', 'nasa-core') . '" rel="nofollow"><svg aria-hidden="true" viewBox="0 0 16 16" version="1.1" width="16" height="16" fill="currentColor"><path d="M8 0c4.42 0 8 3.58 8 8a8.013 8.013 0 0 1-5.45 7.59c-.4.08-.55-.17-.55-.38 0-.27.01-1.13.01-2.2 0-.75-.25-1.23-.54-1.48 1.78-.2 3.65-.88 3.65-3.95 0-.88-.31-1.59-.82-2.15.08-.2.36-1.02-.08-2.12 0 0-.67-.22-2.2.82-.64-.18-1.32-.27-2-.27-.68 0-1.36.09-2 .27-1.53-1.03-2.2-.82-2.2-.82-.44 1.1-.16 1.92-.08 2.12-.51.56-.82 1.28-.82 2.15 0 3.06 1.86 3.75 3.64 3.95-.23.2-.44.55-.51 1.07-.46.21-1.61.55-2.33-.66-.15-.24-.6-.83-1.23-.82-.67.01-.27.38.01.53.34.19.73.9.82 1.13.16.45.68 1.31 2.69.94 0 .67.01 1.3.01 1.49 0 .21-.15.45-.55.38A7.995 7.995 0 0 1 0 8c0-4.42 3.58-8 8-8Z"/></svg></a>';
    }
    
    /**
     * Dribbble
     */
    if ($dribbble) {
        $follow .= '<a href="' . esc_url($dribbble) . '" target="_blank" class="icon icon_dribbble ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Dribbble', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 16 16" width="18" height="18" fill="currentColor"><path d="M 7.5 1 C 3.917969 1 1 3.917969 1 7.5 C 1 11.082031 3.917969 14 7.5 14 C 11.082031 14 14 11.082031 14 7.5 C 14 3.917969 11.082031 1 7.5 1 Z M 7.5 2 C 8.804688 2 10 2.453125 10.941406 3.210938 C 10.464844 3.796875 9.585938 4.613281 8.113281 5.148438 C 7.3125 3.703125 6.644531 2.777344 6.179688 2.164063 C 6.601563 2.0625 7.042969 2 7.5 2 Z M 5.1875 2.515625 C 5.578125 3.019531 6.285156 3.964844 7.125 5.445313 C 4.964844 6.011719 3.015625 6.046875 2.203125 6.023438 C 2.636719 4.460938 3.738281 3.183594 5.1875 2.515625 Z M 11.660156 3.90625 C 12.492188 4.871094 13 6.125 13 7.5 C 13 7.707031 12.988281 7.90625 12.964844 8.105469 C 12.785156 8.082031 12.648438 8.058594 12.417969 8.039063 C 11.644531 7.980469 10.617188 7.980469 9.507813 8.144531 C 9.21875 7.390625 8.898438 6.695313 8.570313 6.042969 C 10.117188 5.453125 11.09375 4.582031 11.660156 3.90625 Z M 7.601563 6.351563 C 7.917969 6.96875 8.222656 7.632813 8.507813 8.34375 C 7.191406 8.734375 5.996094 9.625 5.078125 10.453125 C 4.585938 10.890625 4.183594 11.308594 3.882813 11.636719 C 2.730469 10.628906 2 9.152344 2 7.5 C 2 7.335938 2.011719 7.179688 2.023438 7.019531 C 2.734375 7.050781 5.011719 7.070313 7.601563 6.351563 Z M 10.910156 9.007813 C 11.679688 8.980469 12.285156 9.03125 12.765625 9.085938 C 12.402344 10.308594 11.625 11.347656 10.597656 12.046875 C 10.433594 11.019531 10.175781 10.03125 9.867188 9.101563 C 10.226563 9.054688 10.578125 9.023438 10.910156 9.007813 Z M 8.867188 9.285156 C 9.222656 10.3125 9.503906 11.410156 9.664063 12.558594 C 9 12.839844 8.269531 13 7.5 13 C 6.472656 13 5.519531 12.714844 4.695313 12.230469 C 4.972656 11.933594 5.316406 11.574219 5.742188 11.195313 C 6.625 10.402344 7.777344 9.59375 8.867188 9.285156 Z"/></svg></a>';
    }
    
    /**
     * Behance
     */
    if ($behance) {
        $follow .= '<a href="' . esc_url($behance) . '" target="_blank" class="icon icon_behance ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Behance', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="18" height="18" fill="currentColor"><path d="M 5.5 10 C 3.5850452 10 2 11.585045 2 13.5 L 2 22.5 L 2 34.5 C 2 36.414955 3.5850452 38 5.5 38 L 16.5 38 C 21.176657 38 25 34.176657 25 29.5 C 25 26.543503 23.379856 24.055298 21.074219 22.53125 C 22.801509 21.25305 24 19.299926 24 17 C 24 13.151598 20.848402 10 17 10 L 5.5 10 z M 33.511719 12 C 32.683719 12 32.011719 12.672 32.011719 13.5 C 32.011719 14.328 32.683719 15 33.511719 15 L 41.511719 15 C 42.340719 15 43.011719 14.328 43.011719 13.5 C 43.011719 12.672 42.339719 12 41.511719 12 L 33.511719 12 z M 5.5 13 L 17 13 C 19.227598 13 21 14.772402 21 17 C 21 19.227598 19.227598 21 17 21 L 16.5 21 L 5 21 L 5 13.5 C 5 13.204955 5.2049548 13 5.5 13 z M 36.996094 17 C 31.659366 17 27.447365 21.432718 27.119141 26.867188 A 1.50015 1.50015 0 0 0 27.119141 28.136719 C 27.449267 33.56954 31.661439 38 36.996094 38 C 40.48059 38 43.922192 36.22655 45.767578 33.304688 A 1.50015 1.50015 0 1 0 43.232422 31.701172 C 42.029808 33.60531 39.405598 35 36.996094 35 C 33.648827 35 30.947255 32.433758 30.279297 29 L 44.484375 29 C 45.956288 29 47.146993 27.682151 46.974609 26.208984 L 46.974609 26.207031 C 46.371622 21.051926 42.12622 17 36.996094 17 z M 36.996094 20 C 40.351317 20 43.159364 22.565302 43.828125 26 L 30.279297 26 C 30.947042 22.566148 33.647795 20 36.996094 20 z M 5 24 L 16.5 24 C 19.555343 24 22 26.444657 22 29.5 C 22 32.555343 19.555343 35 16.5 35 L 5.5 35 C 5.2049548 35 5 34.795045 5 34.5 L 5 24 z"/></svg></a>';
    }
    
    /**
     * Soundcloud
     */
    if ($soundcloud) {
        $follow .= '<a href="' . esc_url($soundcloud) . '" target="_blank" class="icon icon_soundcloud ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Soundcloud', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 50 50" width="20" height="20" fill="currentColor"><path d="M 30 11 C 26.398438 11 23 12.789063 21 15.6875 L 21 19.1875 L 21.3125 19.40625 L 21.6875 18.40625 C 23.085938 15.105469 26.40625 13 29.90625 13 C 34.90625 13 38.90625 17 38.90625 22 L 38.90625 24 L 40.40625 23.40625 C 41.105469 23.105469 41.800781 23 42.5 23 C 45.5 23 48 25.5 48 28.5 C 48 31.5 45.5 34 42.5 34 L 21 34 L 21 36 L 42.5 36 C 46.601563 36 50 32.601563 50 28.5 C 50 24.398438 46.601563 21 42.5 21 C 42 21 41.5 21.085938 41 21.1875 C 40.5 15.488281 35.800781 11 30 11 Z M 17 16 C 16.300781 16 15.601563 16.085938 15 16.1875 L 15 36 L 17 36 Z M 18 16 L 18 36 L 20 36 L 20 16.5 C 19.398438 16.300781 18.699219 16.101563 18 16 Z M 14 16.5 C 13.300781 16.800781 12.601563 17.101563 12 17.5 L 12 36 L 14 36 Z M 11 18.3125 C 10.199219 19.011719 9.5 19.90625 9 20.90625 L 9 36 L 11 36 Z M 6.5 22 C 6.324219 22.011719 6.148438 22.042969 6 22.09375 L 6 35.90625 C 6.300781 36.007813 6.699219 36 7 36 L 8 36 L 8 22.09375 C 7.699219 21.992188 7.300781 22 7 22 C 6.851563 22 6.675781 21.988281 6.5 22 Z M 5 22.3125 C 4.300781 22.511719 3.601563 22.8125 3 23.3125 L 3 34.6875 C 3.601563 35.085938 4.300781 35.488281 5 35.6875 Z M 2 24.09375 C 0.800781 25.394531 0 27.101563 0 29 C 0 30.898438 0.800781 32.605469 2 33.90625 Z"/></svg></a>';
    }
    
    /**
     * Spotify
     */
    if ($spotify) {
        $follow .= '<a href="' . esc_url($spotify) . '" target="_blank" class="icon icon_spotify ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Spotify', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="18" height="18" fill="currentColor"><path d="M 24 4 C 12.972066 4 4 12.972074 4 24 C 4 35.027926 12.972066 44 24 44 C 35.027934 44 44 35.027926 44 24 C 44 12.972074 35.027934 4 24 4 z M 24 7 C 33.406615 7 41 14.593391 41 24 C 41 33.406609 33.406615 41 24 41 C 14.593385 41 7 33.406609 7 24 C 7 14.593391 14.593385 7 24 7 z M 21.103516 15.957031 C 20.389873 15.966128 19.676597 15.999862 18.964844 16.058594 C 17.066835 16.215211 15.180218 16.549094 13.332031 17.058594 A 1.50015 1.50015 0 1 0 14.128906 19.949219 C 20.796159 18.111219 28.02435 18.821382 34.261719 22.074219 A 1.50015 1.50015 0 1 0 35.648438 19.414062 C 31.106773 17.045549 26.099015 15.893354 21.103516 15.957031 z M 21.308594 22.009766 C 20.725031 22.014043 20.140835 22.038263 19.558594 22.082031 C 18.005952 22.198747 16.46251 22.455787 14.947266 22.853516 A 1.50015 1.50015 0 1 0 15.708984 25.753906 C 21.062005 24.34882 26.832615 24.930095 31.841797 27.496094 A 1.50015 1.50015 0 1 0 33.208984 24.826172 C 29.483573 22.917796 25.39353 21.979821 21.308594 22.009766 z M 21.546875 28.017578 C 21.101253 28.016517 20.655896 28.029198 20.210938 28.056641 C 19.02438 28.129821 17.84235 28.304165 16.679688 28.580078 A 1.50015 1.50015 0 1 0 17.373047 31.498047 C 21.352394 30.553701 25.596764 30.99901 29.326172 32.830078 A 1.5002142 1.5002142 0 1 0 30.648438 30.136719 C 27.784174 28.73042 24.666231 28.025008 21.546875 28.017578 z"/></svg></a>';
    }
    
    /**
     * Odnoklassniki
     */
    if ($ok) {
        $follow .= '<a href="' . esc_url($ok) . '" target="_blank" class="icon icon_ok ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Odnoklassniki', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 48 48" width="16" height="16" fill="currentColor"><path d="M 24 2 C 17.925 2 13 6.925 13 13 C 13 19.075 17.925 24 24 24 C 30.075 24 35 19.075 35 13 C 35 6.925 30.075 2 24 2 z M 24 8.9472656 C 26.238 8.9472656 28.052734 10.761 28.052734 13 C 28.052734 15.238 26.238 17.052734 24 17.052734 C 21.762 17.052734 19.947266 15.239 19.947266 13 C 19.947266 10.762 21.761 8.9472656 24 8.9472656 z M 33.185547 24.046875 C 32.402922 24.009469 31.6245 24.203187 30.9375 24.617188 C 26.7875 27.116187 21.2115 27.116187 17.0625 24.617188 C 15.1725 23.478188 12.710266 24.090469 11.572266 25.980469 C 11.021266 26.896469 10.858234 27.970813 11.115234 29.007812 C 11.373234 30.044812 12.019547 30.920703 12.935547 31.470703 C 14.396547 32.350703 15.959516 33.049594 17.603516 33.558594 L 12.009766 39.339844 C 11.300766 40.138844 10.942859 41.165422 11.005859 42.232422 C 11.068859 43.299422 11.542797 44.276328 12.341797 44.986328 C 13.105797 45.665328 14.060812 45.998047 15.007812 45.998047 C 16.103813 45.998047 17.189938 45.552547 17.960938 44.685547 L 24 38.443359 L 30.013672 44.652344 C 30.771672 45.506344 31.861906 45.994141 33.003906 45.994141 C 33.982906 45.994141 34.926156 45.635375 35.660156 44.984375 C 37.308156 43.519375 37.458844 40.986641 35.964844 39.306641 L 30.396484 33.558594 C 32.040484 33.048594 33.605406 32.34875 35.066406 31.46875 C 35.981406 30.91775 36.627766 30.044813 36.884766 29.007812 C 37.141766 27.970813 36.978734 26.895469 36.427734 25.980469 C 35.876734 25.065469 35.003797 24.419109 33.966797 24.162109 C 33.707797 24.097609 33.446422 24.059344 33.185547 24.046875 z"/></svg></a>';
    }
    
    /**
     * Discord
     */
    if ($discord) {
        $follow .= '<a href="' . esc_url($discord) . '" target="_blank" class="icon icon_discord ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Discord', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M19.952,5.672c-1.904-1.531-4.916-1.79-5.044-1.801c-0.201-0.017-0.392,0.097-0.474,0.281 c-0.006,0.012-0.072,0.163-0.145,0.398c1.259,0.212,2.806,0.64,4.206,1.509c0.224,0.139,0.293,0.434,0.154,0.659 c-0.09,0.146-0.247,0.226-0.407,0.226c-0.086,0-0.173-0.023-0.252-0.072C15.584,5.38,12.578,5.305,12,5.305S8.415,5.38,6.011,6.872 c-0.225,0.14-0.519,0.07-0.659-0.154c-0.14-0.225-0.07-0.519,0.154-0.659c1.4-0.868,2.946-1.297,4.206-1.509 c-0.074-0.236-0.14-0.386-0.145-0.398C9.484,3.968,9.294,3.852,9.092,3.872c-0.127,0.01-3.139,0.269-5.069,1.822 C3.015,6.625,1,12.073,1,16.783c0,0.083,0.022,0.165,0.063,0.237c1.391,2.443,5.185,3.083,6.05,3.111c0.005,0,0.01,0,0.015,0 c0.153,0,0.297-0.073,0.387-0.197l0.875-1.202c-2.359-0.61-3.564-1.645-3.634-1.706c-0.198-0.175-0.217-0.477-0.042-0.675 c0.175-0.198,0.476-0.217,0.674-0.043c0.029,0.026,2.248,1.909,6.612,1.909c4.372,0,6.591-1.891,6.613-1.91 c0.198-0.172,0.5-0.154,0.674,0.045c0.174,0.198,0.155,0.499-0.042,0.673c-0.07,0.062-1.275,1.096-3.634,1.706l0.875,1.202 c0.09,0.124,0.234,0.197,0.387,0.197c0.005,0,0.01,0,0.015,0c0.865-0.027,4.659-0.667,6.05-3.111 C22.978,16.947,23,16.866,23,16.783C23,12.073,20.985,6.625,19.952,5.672z M8.891,14.87c-0.924,0-1.674-0.857-1.674-1.913 s0.749-1.913,1.674-1.913s1.674,0.857,1.674,1.913S9.816,14.87,8.891,14.87z M15.109,14.87c-0.924,0-1.674-0.857-1.674-1.913 s0.749-1.913,1.674-1.913c0.924,0,1.674,0.857,1.674,1.913S16.033,14.87,15.109,14.87z"/></svg></a>';
    }
    
    /**
     * Amazon
     */
    if ($amazon) {
        $follow .= '<a href="' . esc_url($amazon) . '" target="_blank" class="icon icon_amazon ' . esc_attr($class_tip) . '" title="' . esc_attr__('Follow us on Amazon', 'nasa-core') . '" rel="nofollow"><svg viewBox="0 0 30 30" width="16" height="16" fill="currentColor"><path d="M 15.183594 3 C 11.820594 3 8.0848281 4.2580938 7.2988281 8.3710938 C 7.2148281 8.8090937 7.5215469 9.0336562 7.8105469 9.0976562 L 11.224609 9.4453125 C 11.545609 9.4283125 11.801281 9.1304531 11.863281 8.8144531 C 12.157281 7.3974531 13.357125 6.6972656 14.703125 6.6972656 C 15.430125 6.6972656 16.253594 6.9692812 16.683594 7.6132812 C 17.180594 8.3322813 17.097656 9.3095781 17.097656 10.142578 L 17.097656 10.615234 C 15.048656 10.843234 12.376937 10.982406 10.460938 11.816406 C 8.2469375 12.763406 6.6933594 14.695156 6.6933594 17.535156 C 6.6933594 21.169156 9.0171875 23.001953 11.992188 23.001953 C 14.505187 23.001953 15.860781 22.399359 17.800781 20.443359 C 18.441781 21.362359 18.66975 21.81425 19.84375 22.78125 C 20.10775 22.92125 20.440828 22.8955 20.673828 22.6875 L 20.673828 22.71875 C 21.378828 22.09675 22.664766 20.981859 23.384766 20.380859 C 23.671766 20.146859 23.609766 19.781891 23.384766 19.462891 C 22.738766 18.579891 22.076172 17.847031 22.076172 16.207031 L 22.076172 10.771484 C 22.076172 8.4624844 22.232672 6.3263281 20.513672 4.7363281 C 19.156672 3.4483281 16.901594 3 15.183594 3 z M 16.140625 13.425781 C 16.459625 13.404781 16.777656 13.425781 17.097656 13.425781 L 17.097656 14.183594 C 17.098656 15.547594 17.152984 16.668859 16.458984 17.880859 C 15.896984 18.864859 14.993953 19.460938 14.001953 19.460938 C 12.645953 19.460938 11.861328 18.445641 11.861328 16.931641 C 11.861328 14.326641 13.910625 13.570781 16.140625 13.425781 z M 26.080078 22.220703 C 25.171078 22.233703 24.106016 22.424234 23.291016 22.990234 C 23.041016 23.164234 23.077469 23.409953 23.355469 23.376953 C 24.272469 23.267953 26.299063 23.011656 26.664062 23.472656 C 27.028063 23.934656 26.261922 25.832641 25.919922 26.681641 C 25.815922 26.937641 26.041391 27.036797 26.275391 26.841797 C 27.801391 25.577797 28.208484 22.956266 27.896484 22.572266 C 27.741484 22.385266 26.990078 22.207703 26.080078 22.220703 z M 2.1777344 22.701172 C 1.9877344 22.726172 1.9132812 22.973344 2.1132812 23.152344 C 5.5052812 26.184344 9.9770781 28 14.955078 28 C 18.506078 28 22.651094 26.899312 25.496094 24.820312 C 25.966094 24.475313 25.557172 23.943484 25.076172 24.146484 C 21.887172 25.486484 18.401047 26.136719 15.248047 26.136719 C 10.573047 26.136719 6.06525 24.873625 2.40625 22.765625 C 2.32525 22.719625 2.2397344 22.693172 2.1777344 22.701172 z"/></svg></a>';
    }
    
    $follow_content = apply_filters('nasa_follow_content', $follow);
    
    $follow_wrap_end = '</div></div>';

    return $follow_content ? $follow_wrap_start . $follow_content . $follow_wrap_end : '';
}

/**
 * Register Params
 */
function nasa_register_share_follow(){
    $share_params = array(
        "name" => "Share",
        "base" => "nasa_share",
        'icon' => 'icon-wpb-nasatheme',
        'description' => __("Display share icon social.", 'nasa-core'),
        "content_element" => true,
        "category" => 'Nasa Core',
        "show_settings_on_create" => false,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => __('Title', 'nasa-core'),
                "param_name" => 'title'
            ),
            array(
                "type" => "textfield",
                "heading" => __("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    );
    vc_map($share_params);

    // **********************************************************************// 
    // ! Register New Element: Follow
    // **********************************************************************//
    $follow = array(
        "name" => "Follow",
        "base" => "nasa_follow",
        'icon' => 'icon-wpb-nasatheme',
        'description' => __("Display Follow icon social.", 'nasa-core'),
        "content_element" => true,
        "category" => 'Nasa Core',
        "show_settings_on_create" => false,
        "params" => array(
            array(
                "type" => "textfield",
                "heading" => __('Title', 'nasa-core'),
                "param_name" => 'title'
            ),
            array(
                "type" => "textfield",
                "heading" => __('X', 'nasa-core'),
                "param_name" => 'twitter'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Facebook', 'nasa-core'),
                "param_name" => 'facebook'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Pinterest', 'nasa-core'),
                "param_name" => 'pinterest'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Email', 'nasa-core'),
                "param_name" => 'email'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Instagram', 'nasa-core'),
                "param_name" => 'instagram'
            ),
            array(
                "type" => "textfield",
                "heading" => __('RSS', 'nasa-core'),
                "param_name" => 'rss'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Linkedin', 'nasa-core'),
                "param_name" => 'linkedin'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Youtube', 'nasa-core'),
                "param_name" => 'youtube'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Flickr', 'nasa-core'),
                "param_name" => 'flickr'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Telegram', 'nasa-core'),
                "param_name" => 'telegram'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Whatsapp', 'nasa-core'),
                "param_name" => 'whatsapp'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Tiktok', 'nasa-core'),
                "param_name" => 'tiktok'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Weibo', 'nasa-core'),
                "param_name" => 'weibo'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Snapchat', 'nasa-core'),
                "param_name" => 'snapchat'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Amazon', 'nasa-core'),
                "param_name" => 'amazon'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Tumblr', 'nasa-core'),
                "param_name" => 'tumblr'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Vimeo', 'nasa-core'),
                "param_name" => 'vimeo'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Github', 'nasa-core'),
                "param_name" => 'github'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Dribbble', 'nasa-core'),
                "param_name" => 'dribbble'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Behance', 'nasa-core'),
                "param_name" => 'behance'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Soundcloud', 'nasa-core'),
                "param_name" => 'soundcloud'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Spotify', 'nasa-core'),
                "param_name" => 'spotify'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Odnoklassniki', 'nasa-core'),
                "param_name" => 'ok'
            ),
            array(
                "type" => "textfield",
                "heading" => __('Discord', 'nasa-core'),
                "param_name" => 'discord'
            ),

            array(
                "type" => "dropdown",
                "heading" => __('Tip Position', 'nasa-core'),
                "param_name" => 'tip',
                "value" => array(
                    __('Top', 'nasa-core') => '',
                    __('Left', 'nasa-core') => 'left',
                    __('Right', 'nasa-core') => 'right',
                    __('Bottom', 'nasa-core') => 'bottom'
                ),
            ),
            array(
                "type" => "textfield",
                "heading" => __("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    );

    vc_map($follow);
}
