<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Contact Form - Vehicle Import Inquiry with Mailchimp</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter&display=swap');
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #6366f1, #8b5cf6);
      color: #f9fafb;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
      padding: 16px;
    }

    .form-container {
      background: rgba(255 255 255 / 0.1);
      backdrop-filter: blur(12px);
      padding: 32px 40px;
      border-radius: 16px;
      width: 100%;
      max-width: 480px;
      box-shadow: 0 4px 30px rgba(0,0,0,0.3);
    }

    h1 {
      font-weight: 700;
      font-size: 1.8rem;
      margin-bottom: 24px;
      text-align: center;
      color: #eef2ff;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 600;
      font-size: 0.95rem;
      color: #e0e7ff;
    }

    input[type="text"],
    input[type="email"],
    select {
      width: 100%;
      padding: 12px 14px;
      border-radius: 8px;
      border: none;
      outline: none;
      font-size: 1rem;
      margin-bottom: 20px;
      background-color: rgba(255 255 255 / 0.15);
      color: #f0f0ff;
      transition: background-color 0.3s ease;
    }
    input[type="text"]:focus,
    input[type="email"]:focus,
    select:focus {
      background-color: rgba(255 255 255 / 0.3);
      box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.8);
    }

    button {
      width: 100%;
      padding: 14px 0;
      background: linear-gradient(135deg, #8b5cf6, #6366f1);
      border: none;
      border-radius: 12px;
      font-size: 1.2rem;
      color: white;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.4s ease;
    }
    button:hover {
      background: linear-gradient(135deg, #5c3ac7, #4338ca);
    }

    .success-message {
      margin-top: 20px;
      background-color: rgba(16, 185, 129, 0.8);
      color: #e0f2f1;
      padding: 12px;
      border-radius: 8px;
      font-weight: 600;
      text-align: center;
    }

    .error-message {
      margin-top: 20px;
      background-color: rgba(239, 68, 68, 0.8);
      color: #fef2f2;
      padding: 12px;
      border-radius: 8px;
      font-weight: 600;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="form-container" role="main" aria-label="Vehicle import inquiry contact form">
    <h1>Vehicle Import Inquiry</h1>
    <?php
      $success = '';
      $error = '';

      // MAILCHIMP CONFIGURATION - Enter your details here
      $mailchimpApiKey = 'YOUR_API_KEY_HERE'; // e.g. 'abcd1234-us1'
      $mailchimpListId = 'YOUR_LIST_ID_HERE'; // Your audience ID
      // Extract datacenter prefix from API key (last part after '-')
      $dataCenter = explode('-', $mailchimpApiKey)[1] ?? '';
      
      if ($_SERVER["REQUEST_METHOD"] === "POST") {
        $name = trim($_POST['name'] ?? '');
        $contact = trim($_POST['contact'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $vehicleType = $_POST['vehicle_type'] ?? '';
        $country = $_POST['country'] ?? '';

        // Validation
        if (!$name) {
          $error = "Please enter your name.";
        } elseif (!$contact) {
          $error = "Please enter your contact number.";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
          $error = "Please enter a valid email address.";
        } elseif (!$vehicleType) {
          $error = "Please select a type of vehicle.";
        } elseif (!$country) {
          $error = "Please select your country.";
        }

        if (!$error) {
          // Prepare data for Mailchimp API - subscriber data
          // Merge fields must be configured in Mailchimp audience for VEHICLE and COUNTRY if you want to store them properly.
          $memberId = md5(strtolower($email));
          $url = "https://$dataCenter.api.mailchimp.com/3.0/lists/$mailchimpListId/members/$memberId";

          $json = json_encode([
            'email_address' => $email,
            'status_if_new' => 'subscribed',  // 'subscribed' to add the user or update status
            'merge_fields' => [
              'FNAME' => $name,
              'PHONE' => $contact,
              'VEHICLE' => $vehicleType,   // Replace with your actual merge field tag
              'COUNTRY' => $country         // Replace with your actual merge field tag
            ]
          ]);

          $ch = curl_init($url);
          curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $mailchimpApiKey);
          curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch, CURLOPT_TIMEOUT, 10);
          curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT'); // Use PUT to add or update
          curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

          $result = curl_exec($ch);
          $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
          curl_close($ch);

          if ($httpCode == 200) {
            $success = "Thank you, your inquiry has been added to our mailing list!";
            // Clear form values
            $name = $contact = $email = $vehicleType = $country = '';
          } else {
            $error = "There was an error subscribing you to the mailing list. Please try again later.";
          }
        }
      }
    ?>

    <?php if ($success): ?>
      <div class="success-message" role="alert"><?=htmlspecialchars($success)?></div>
    <?php endif; ?>
    <?php if ($error): ?>
      <div class="error-message" role="alert"><?=htmlspecialchars($error)?></div>
    <?php endif; ?>

    <form method="post" action="<?=htmlspecialchars($_SERVER["PHP_SELF"])?>" novalidate>
      <label for="name">Name</label>
      <input 
        type="text" 
        id="name" 
        name="name" 
        value="<?=htmlspecialchars($name ?? '')?>" 
        required 
        autocomplete="name"
        aria-required="true"
      />

      <label for="contact">Contact Number</label>
      <input 
        type="text" 
        id="contact" 
        name="contact" 
        value="<?=htmlspecialchars($contact ?? '')?>" 
        required 
        autocomplete="tel"
        aria-required="true"
      />

      <label for="email">Email Address</label>
      <input 
        type="email" 
        id="email" 
        name="email" 
        value="<?=htmlspecialchars($email ?? '')?>" 
        required 
        autocomplete="email"
        aria-required="true"
      />

      <label for="vehicle_type">Type of Vehicle</label>
      <select id="vehicle_type" name="vehicle_type" required aria-required="true">
        <option value="" disabled <?=empty($vehicleType) ? 'selected' : ''?>>Select Vehicle Type</option>
        <option value="Industrial Vehicle" <?=($vehicleType ?? '') === 'Industrial Vehicle' ? 'selected' : ''?>>Industrial Vehicle</option>
        <option value="Commercial Vehicle" <?=($vehicleType ?? '') === 'Commercial Vehicle' ? 'selected' : ''?>>Commercial Vehicle</option>
        <option value="Private Vehicle" <?=($vehicleType ?? '') === 'Private Vehicle' ? 'selected' : ''?>>Private Vehicle</option>
      </select>

      <label for="country">Country</label>
      <select id="country" name="country" required aria-required="true">
        <option value="" disabled <?=empty($country) ? 'selected' : ''?>>Select Country</option>
        <option value="United States" <?=($country ?? '') === 'United States' ? 'selected' : ''?>>United States</option>
        <option value="Canada" <?=($country ?? '') === 'Canada' ? 'selected' : ''?>>Canada</option>
        <option value="United Kingdom" <?=($country ?? '') === 'United Kingdom' ? 'selected' : ''?>>United Kingdom</option>
        <option value="Australia" <?=($country ?? '') === 'Australia' ? 'selected' : ''?>>Australia</option>
        <option value="Germany" <?=($country ?? '') === 'Germany' ? 'selected' : ''?>>Germany</option>
        <option value="India" <?=($country ?? '') === 'India' ? 'selected' : ''?>>India</option>
        <option value="Brazil" <?=($country ?? '') === 'Brazil' ? 'selected' : ''?>>Brazil</option>
        <option value="China" <?=($country ?? '') === 'China' ? 'selected' : ''?>>China</option>
        <option value="South Africa" <?=($country ?? '') === 'South Africa' ? 'selected' : ''?>>South Africa</option>
      </select>

      <button type="submit" aria-label="Submit contact form">Submit Inquiry</button>
    </form>
  </div>
</body>
</html>

